' Program ENC_Test.BAS
' Rotary Encoder Reader using the Include file ENCODER.INC

' To read the Rotary encoder call the subroutine ENCODER
' Upon its return, the variable DIRECTION will hold the specific direction of the encoder
' A result of 128 (Bit-7) means encoder turning left
' A result of 1 (Bit-0) means encoder turning right
' A result of 0 means the encoder is stationary


' Three new defines establish which Port and pins the Rotary encoder is attached to
' as well as enabling the portB pullups resistors
' These are: -

'	Define	ENC_PORT
'	Define  ENC_BIT		
'	Define  ENC_PULLUPS

' ENC_PORT defines which PORT the encoder is attached to.

' ENC_BIT defines which BIT Channel-A of the encoder is attached to
' Channel-B of the encoder must be attached to the next bit up
' For instance if the define ENC_BIT is given the value 0 then
' Channel-A will be attached to PortB.0, and Channel-B will be attached to PortB.1

' ENC_PULLUPS will enable the internal PortB pullups is set to 1,
' and disable the resistors if 0

' The result is sent serially from PortA.0

	Include "Modedefs.Bas"
	Include "Encoder.Inc"			' Load the Rotary encoder subroutine

' ** Set Xtal Value in Mhz

	Define	OSC		4		' Set Xtal Frequency

' ** Set Debug Defines **

	Define	DEBUG_REG	PortA		' Debug PORTA
	Define	DEBUG_BIT	0		' *** Debug pin Bit0 ***
	Define	DEBUG_BAUD	9600		' *** Debug Baud Rate ***
	Define	DEBUG_MODE	1		' Set Serial Mode 1=Inverted
	Define	DEBUG_PACING	100		' Delay 'in us' between characters sent

' ** Declare the variables used in the demo program **

	Counter		Var	Word		' General Purpose counter for Demo Loop
	Led1		Var	PortA.1
	Led2		Var	PortA.2

' ** New Defines for Rotary Encoder **

	Define	ENC_PORT	PortB		' Encoder Port
	Define	ENC_BIT		0		' Encoder CH-A Bit,CH-B bit is the next bit up
	Define  ENC_PULLUPS	1		' Enable or Disable the internal Pullups	

' ** MAIN DEMO LOOP STARTS HERE **
	Pause 400
	Debug I,Clr:Pause 30			' Clear the LCD
	Counter=0				' Reset the Counter variable
Loop:	Gosub Encoder				' Read the Rotary Encoder

	If Direction=0 then
	Low Led1
	Low Led2
	Endif

	If Direction.0=1 then 
	Counter=Counter+1
	Low Led1
	High Led2
	Endif

	If Direction.7=1 then 
	Counter=Counter-1
	Low Led2
	High Led1
	Endif

	Debug I,Line1,#Counter,"    "
	Goto Loop


